//
//  TodoList.swift
//  Do It
//
//  Created by Jim Dovey on 5/10/20.
//  Copyright © 2020 Pragmatic Programmers. All rights reserved.
//

import SwiftUI

struct TodoList: View {
    // START:body
    var body: some View {
        NavigationView {
            List(defaultTodoItems) { item in
                NavigationLink(destination: Text(item.title)) {
                    VStack(alignment: .leading) {
                        Text(item.title)
                            .font(.headline)
                        
                        if item.notes != nil {
                            Text(item.notes!)
                                .font(.subheadline)
                        }
                    }
                }
            }
            .navigationBarTitle("To-Do Items")
            .listStyle(GroupedListStyle())
        }
    }
    // END:Body
}

struct TodoList_Previews: PreviewProvider {
    static var previews: some View {
        TodoList()
    }
}
